//********************************************************************
//  RandomGUI.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 4.13 (5E, p. 204)
//********************************************************************

import java.awt.Dimension;
import java.awt.event.*;
import javax.swing.*;
import java.util.Random;

public class RandomGUI
{
   private int WIDTH = 100;
   private int HEIGHT = 75;
   private int MAX_NUMBER = 100;

   private JFrame frame;
   private JPanel panel;
   private JLabel numberLabel;
   private JButton randomButton;
   private Random generator;

   //-----------------------------------------------------------------
   //  Sets up the GUI.
   //-----------------------------------------------------------------
   public RandomGUI()
   {
      frame = new JFrame ("Random Display");
      frame.setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);

      generator = new Random();

      numberLabel = new JLabel (String.valueOf(generator.nextInt(MAX_NUMBER)+1));

      randomButton = new JButton("New Number");
      randomButton.addActionListener (new RandomListener());

      panel = new JPanel();
      panel.setPreferredSize (new Dimension(WIDTH, HEIGHT));
      panel.add (numberLabel);
      panel.add(randomButton);

      frame.getContentPane().add (panel);
   }

   //-----------------------------------------------------------------
   //  Displays the primary application frame.
   //-----------------------------------------------------------------
   public void display()
   {
      frame.pack();
      frame.setVisible(true);
   }

   //*****************************************************************
   //  Represents an action listener for the random button.
   //*****************************************************************
   private class RandomListener implements ActionListener
   {
      //--------------------------------------------------------------
      //  Generates and displays a new random number
      //--------------------------------------------------------------
      public void actionPerformed (ActionEvent event)
      {
         numberLabel.setText (Integer.toString (generator.nextInt(MAX_NUMBER)+1));
      }
   }
}
